qui {
noisily {
	/*************************************************/
	/*** Step 1.12. Summary statistics 			  ****/
	/*************************************************/
	}

/* 1.12.1. Summary statistics of all constructed variables */

	/* Table 1. Summary statistics: Established countries vs. NICs */

		* Define relevant variables
						
			local vars baseline_gdpcap market_potential pop educ health open bdeaths dem crisis

			label var baseline_gdpcap "GDP per capita"
			label var open "Openness"
			label var dem "Democracy"
			label var crisis "Financial crises"
			label var educ "Years of schooling"
			label var health "Life expectancy"
			label var popdens "Population density"
			label var bdeaths "Battle deaths per 1000 heads"
			label var pop "Population (millions)"
			label var market_potential "Market potential (millions)"

		* Generate their mean (differences)
			
			preserve
			replace pop = pop/1000000 								// Divide population to increase legibility
			replace market_potential = market_potential/1000000		// Divide market potential to increase legibility
			replace bdeaths = bdeaths*1000							// Multiply per capita battle deaths to increase legibility

			tempname postMeans
			tempfile means
			postfile `postMeans' ///
				str100 varname EstablishedN EstablishedMeans EstablishedSE NICN NICMeans NICSE diffMeans pMeans using "`means'", replace
				foreach var of local vars {
					if "`var'" != "crisis" {
						local name: variable label `var'
						ttest `var' if independence_years != . & year >= $startyear, by(independent_newly_identifier) unequal
						post `postMeans' ("`name'") (round(r(N_1),.001)) (round(r(mu_1),.001)) (round(r(sd_1),.001)) (round(r(N_2),.001)) (round(r(mu_2),.001)) (round(r(sd_2),.001)) (round(r(mu_2)-r(mu_1),.001)) (round(r(p),.001))
						}
					else if "`var'" == "crisis" {
						local name: variable label `var'
						ttest `var' if independence_years != .  & year >= $startyear , by(independent_newly_identifier) unequal
						post `postMeans' ("`name'") (round(r(N_1),.001)) (round(r(mu_1),.001)) (round(r(sd_1),.001)) (round(r(N_2),.001)) (round(r(mu_2),.001)) (round(r(sd_2),.001)) (round(r(mu_2)-r(mu_1),.001)) (round(r(p),.001))
						}
				}
			postclose `postMeans'
			restore
			
		* Report results
		
			preserve
			use `means', clear
			format *Means %3.2f
			noi list

			cd ..
			cd ".\5. TeX results"
			listtab * using "table2.tex", ///
				rstyle(tabular) replace ///
				head("\begin{tabular}{lcccccccc}" ///
				"\toprule" ///
				"& \multicolumn{3}{c}{\textbf{Established countries}} & \multicolumn{3}{c}{\textbf{Newly independent countries}} \\" ///
				"\cmidrule(lr){2-4}" "\cmidrule(lr){5-7}" ///
				"\emph{Variable} & \emph{Obs.} & \emph{Mean} & \emph{Std. Dev.} & \emph{Obs.} & \emph{Mean} & \emph{Std. Dev.} & \emph{Mean diff.} & \emph{P-value} \\" ///
				"\midrule") ///
				foot("\bottomrule" "\end{tabular}")
			restore

		* Reroute to directory containing dofiles
		cd ..
		cd ".\1. Dofiles"
}
